*                                                                                  ;
 *    Reading in the 1978 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam78.raw' ;
 
 data one;
 
   infile 'F:\PSID\78FAM.DAT'  lrecl=980 missover;
   INPUT
   V5701 1-3              V5702 4-7              V5703 8-9
   V5704 10-12            V5705 13-17            V5706 18
   V5707 19               V5708 20               V5709 21
   V5710 22               V5711 23               V5712 24
   V5713 25               V5714 26               V5715 27
   V5716 28               V5717 29-34            V5718 35
   V5719 36-40            V5720 41               V5721 42-45
   V5722 46               V5723 47-50            V5724 51
   V5725 52               V5726 53               V5727 54-57
   V5728 58               V5729 59-62            V5730 63
   V5731 64-67            V5732 68               V5733 69-72
   V5734 73               V5735 74-77            V5736 78
   V5737 79-82            V5738 83               V5739 84-87
   V5740 88               V5741 89-91            V5742 92
   V5743 93-96            V5744 97               V5745 98-101
   V5746 102              V5747 103-106          V5748 107
   V5749 108-111          V5750 112              V5751 113-116
   V5752 117              V5753 118-120          V5754 121
   V5755 122-123          V5756 124              V5757 125-129 .2
   V5758 130-134          V5759 135-138          V5760 139
   V5761 140-143          V5762 144              V5763 145-148
   V5764 149              V5765 150              V5766 151-153
   V5767 154              V5768 155-157          V5769 158
   V5770 159-162          V5771 163              V5772 164-167
   V5773 168              V5774 169-172          V5775 173
   V5776 174-177          V5777 178              V5778 179-180
   V5779 181              V5780 182-186          V5781 187-191
   V5782 192-196          V5783 197              V5784 198-202
   V5785 203-207          V5786 208-211          V5787 212
   V5788 213-217          V5789 218              V5790 219-223
   V5791 224-228          V5792 229-232          V5793 233-236
   V5794 237-241          V5795 242-246          V5796 247-251
   V5797 252              V5798 253-257          V5799 258
   V5800 259-263          V5801 264-265          V5802 266-270
   V5803 271              V5804 272-275          V5805 276-280
   V5806 281-285          V5807 286-290          V5808 291-295
   V5809 296-299          V5810 300-304          V5811 305-308
   V5812 309-312          V5813 313-317          V5814 318
   V5815 319-323          V5816 324-327          V5817 328-332
   V5818 333              V5819 334              V5820 335-339
   V5821 340-344          V5822 345-349          V5823 350-354
   V5824 355-359          V5825 360-364          V5826 365-369
   V5827 370-373          V5828 374-378          V5829 379-382
   V5830 383-386          V5831 387-391          V5832 392
   V5833 393              V5834 394              V5835 395-398
   V5836 399-402          V5837 403-406          V5838 407-410
   V5839 411-414          V5840 415-418          V5841 419-422
   V5842 423-426          V5843 427-430          V5844 431-434
   V5845 435-438          V5846 439-440          V5847 441
   V5848 442-444          V5849 445-446          V5850 447-448
   V5851 449              V5852 450-451          V5853 452-453
   V5854 454-455          V5855 456              V5856 457
   V5857 458              V5858 459              V5859 460
   V5860 461              V5861 462-466          V5862 467
   V5863 468              V5864 469              V5865 470
   V5866 471              V5867 472-473          V5868 474
   V5869 475              V5870 476              V5871 477
   V5872 478              V5873 479-480          V5874 481-482
   V5875 483              V5876 484              V5877 485
   V5878 486              V5879 487              V5880 488
   V5881 489              V5882 490              V5883 491
   V5884 492              V5885 493-495          V5886 496
   V5887 497              V5888 498-500          V5889 501-502
   V5890 503              V5891 504              V5892 505
   V5893 506              V5894 507              V5895 508-509
   V5896 510              V5897 511-512          V5898 513
   V5899 514-515          V5900 516              V5901 517-518
   V5902 519              V5903 520-521          V5904 522-523
   V5905 524-525          V5906 526              V5907 527
   V5908 528-531          V5909 532              V5910 533-536
   V5911 537-540          V5912 541-544          V5913 545
   V5914 546-549          V5915 550              V5916 551-552
   V5917 553              V5918 554-557          V5919 558-559
   V5920 560-561          V5921 562              V5922 563-566
   V5923 567              V5924 568              V5925 569
   V5926 570-571          V5927 572              V5928 573
   V5929 574-575          V5930 576              V5931 577
   V5932 578              V5933 579              V5934 580
   V5935 581              V5936 582              V5937 583
   V5938 584              V5939 585              V5940 586
   V5941 587-589          V5942 590              V5943 591
   V5944 592              V5945 593              V5946 594
   V5947 595              V5948 596              V5949 597
   V5950 598              V5951 599-600          V5952 601
   V5953 602              V5954 603              V5955 604
   V5956 605              V5957 606              V5958 607-608
   V5959 609-612          V5960 613              V5961 614
   V5962 615              V5963 616              V5964 617
   V5965 618              V5966 619-621          V5967 622
   V5968 623-626          V5969 627              V5970 628-629
   V5971 630              V5972 631              V5973 632-633
   V5974 634              V5975 635              V5976 636
   V5977 637              V5978 638              V5979 639
   V5980 640              V5981 641              V5982 642
   V5983 643              V5984 644-645          V5985 646-647
   V5986 648              V5987 649-650          V5988 651
   V5989 652-653          V5990 654              V5991 655-656
   V5992 657              V5993 658-659          V5994 660
   V5995 661-662          V5996 663              V5997 664-665
   V5998 666-667          V5999 668-669          V6000 670-671
   V6001 672              V6002 673              V6003 674-675
   V6004 676              V6005 677              V6006 678
   V6007 679              V6008 680              V6009 681
   V6010 682              V6011 683              V6012 684
   V6013 685              V6014 686              V6015 687
   V6016 688              V6017 689              V6018 690-691
   V6019 692-693          V6020 694-695          V6021 696-697
   V6022 698              V6023 699              V6024 700
   V6025 701-702          V6026 703              V6027 704
   V6028 705              V6029 706              V6030 707
   V6031 708              V6032 709              V6033 710-713
   V6034 714              V6035 715              V6036 716
   V6037 717              V6038 718              V6039 719-720
   V6040 721-722          V6041 723              V6042 724-725
   V6043 726              V6044 727-728          V6045 729
   V6046 730-731          V6047 732              V6048 733-734
   V6049 735              V6050 736-737          V6051 738-739
   V6052 740-741          V6053 742              V6054 743-744
   V6055 745              V6056 746              V6057 747-749
   V6058 750              V6059 751              V6060 752
   V6061 753              V6062 754              V6063 755
   V6064 756              V6065 757              V6066 758
   V6067 759              V6068 760-761          V6069 762
   V6070 763              V6071 764              V6072 765-766
   V6073 767-768          V6074 769              V6075 770
   V6076 771              V6077 772              V6078 773
   V6079 774              V6080 775              V6081 776
   V6082 777              V6083 778              V6084 779
   V6085 780              V6086 781              V6087 782
   V6088 783              V6089 784              V6090 785
   V6091 786              V6092 787              V6093 788
   V6094 789              V6095 790              V6096 791
   V6097 792              V6098 793              V6099 794
   V6100 795              V6101 796              V6102 797
   V6103 798              V6104 799-800          V6105 801
   V6106 802              V6107 803              V6108 804
   V6109 805              V6110 806              V6111 807
   V6112 808              V6113 809              V6114 810
   V6115 811              V6116 812-813          V6117 814
   V6118 815              V6119 816              V6120 817
   V6121 818              V6122 819              V6123 820-821
   V6124 822-823          V6125 824-825          V6126 826
   V6127 827              V6128 828-829          V6129 830-832
   V6130 833-834          V6131 835-837          V6132 838
   V6133 839              V6134 840              V6135 841-842
   V6136 843-844          V6137 845-846          V6138 847-848
   V6139 849              V6140 850              V6141 851
   V6142 852              V6143 853-854          V6144 855-857
   V6145 858              V6146 859              V6147 860
   V6148 861              V6149 862              V6150 863
   V6151 864              V6152 865              V6153 866-867
   V6154 868-869          V6155 870-871          V6156 872
   V6157 873-874          V6158 875              V6159 876
   V6160 877              V6161 878              V6162 879
   V6163 880              V6164 881              V6165 882
   V6166 883              V6167 884              V6168 885-887
   V6169 888              V6170 889-891          V6171 892
   V6172 893              V6173 894-898          V6174 899-903
   V6175 904-908          V6176 909-912 .2       V6177 913-916
   V6178 917-920 .2       V6179 921-924 .2       V6180 925
   V6181 926              V6182 927              V6183 928
   V6184 929              V6185 930              V6186 931-932
   V6187 933-934          V6188 935-939          V6189 940
   V6190 941-942 .1       V6191 943-944          V6192 945
   V6193 946              V6194 947              V6195 948
   V6196 949-951          V6197 952              V6198 953
   V6199 954              V6200 955              V6201 956
   V6202 957              V6203 958              V6204 959
   V6205 960              V6206 961              V6207 962
   V6208 963              V6209 964              V6210 965
   V6211 966              V6212 967-968          V6213 969
   V6214 970              V6215 971              V6216 972
   V6217 973              V6218 974              V6219 975
   V6220 976-979          V6221 980;

* SAS LABEL STATEMENT;

LABEL
   V5701 = "STUDY # 768 WAVE 11"
   V5702 = "1978 ID"
   V5703 = "CURRENT STATE 1978"
   V5704 = "CURRENT COUNTY 1978"
   V5705 = "CURRENT ST& CNTY 1978"
   V5706 = "SIZE LGST CTY SMSA 78"
   V5707 = "COLOR OF COVERSHEET 78"
   V5708 = "WHETHER REFUSED 1978"
   V5709 = "TELEPHONE INT? 1978"
   V5710 = "FAMILY COMP CHNG 1978"
   V5711 = "# MOVED IN 1978"
   V5712 = "WHO MOVED IN 1978"
   V5713 = "# MOVED OUT 1978"
   V5714 = "WHO MOVED OUT"
   V5715 = "CURRENT FAM COMP 1978"
   V5716 = "QUALITY OF MATCH 1978"
   V5717 = "1978 HOUSE VALUE (C5)"
   V5718 = "ACC 78 HOUSE VALUE"
   V5719 = "REM MORT PRIN 78 (C7)"
   V5720 = "ACC REM MORT PRIN"
   V5721 = "ANN MORT $  1978 (C8)"
   V5722 = "ACC ANN MORT $"
   V5723 = "ANN RENT 1978 (C11)"
   V5724 = "ACC ANN RENT"
   V5725 = "RENT FURNISHED? (C12)"
   V5726 = "RENT HEATED? (C15)"
   V5727 = "ANN $  IF RENT (C17)"
   V5728 = "ACC ANN $  IF RENT"
   V5729 = "ANN UTILITIES IN 1977"
   V5730 = "ACC ANN UTILITIES"
   V5731 = "HD ANN WRK HRS IN 77"
   V5732 = "ACC HD 77 WRK HRS"
   V5733 = "HD HRS WRK LOST OTH ILL"
   V5734 = "ACC HD HR LOST OTH ILL"
   V5735 = "HD HRS WRK LOST OWN ILL"
   V5736 = "ACC HD HR LOST OWN ILL"
   V5737 = "HD STRIKE HRS 77"
   V5738 = "ACC HD STRIKE HRS 77"
   V5739 = "HD UNEMP HRS 77"
   V5740 = "ACC HD UNEMP HRS 77"
   V5741 = "HD TRAV TO WRK HRS 77"
   V5742 = "ACC HD TRAV TO WRK HR 77"
   V5743 = "WF ANN WRK HRS 1977"
   V5744 = "ACC WF ANN WRK HRS 1977"
   V5745 = "WF HRS WRK LOST OTH ILL"
   V5746 = "ACC WF HR LOST OTH ILL"
   V5747 = "WF HRS WRK LOST SELF ILL"
   V5748 = "ACC WF HR LOST SELF ILL"
   V5749 = "WF STRIKE HRS 1977"
   V5750 = "ACC WF STRIKE HRS 1977"
   V5751 = "WF UNEMP HRS 1977"
   V5752 = "ACC WF UNEMP HRS 1977"
   V5753 = "WF TRAV TO WRK HRS 77"
   V5754 = "ACC WF TRAV TO WRK HR 77"
   V5755 = "1978 FAMILY SIZE"
   V5756 = "# REQUIRED ROOMS 1978"
   V5757 = "1978 WEEKLY FOOD NEED"
   V5758 = "1978 ANN NEED STANDARD"
   V5759 = "WF ANN HSEWRK HRS (G39)"
   V5760 = "ACC WF ANN HSEWRK HRS"
   V5761 = "HD ANN HSEWRK HRS (G40)"
   V5762 = "ACC HD ANN HSEWRK HRS"
   V5763 = "OTH ANN HSEWRK HR (G44)"
   V5764 = "ACC OTH ANN HSEWRK HRS"
   V5765 = "# FD ST ISSUED FOR (G47)"
   V5766 = "$  PAID FD ST LAST MO"
   V5767 = "ACC $  PAID FD ST LAST MO"
   V5768 = "$  BONUS PD ST LAST MO"
   V5769 = "ACC BONUS FDSTMP LST MO"
   V5770 = "ANN FD $  EXCL FDSTMP"
   V5771 = "ACC ANN FOOD $"
   V5772 = "ANN $  EATING OUT"
   V5773 = "ACC ANN $  EATING OUT"
   V5774 = "$  PAID FDSTMP 1977"
   V5775 = "ACC $  PAID FDSTMP 1977"
   V5776 = "$  BONUS FDSTMP 1977"
   V5777 = "ACC $  BONUS FDSTMP 1977"
   V5778 = "# MONTHS USED FDSTMP 77"
   V5779 = "# MAJOR ADULTS 1978"
   V5780 = "LABOR PART FARM Y 1977"
   V5781 = "LABOR PART BUS Y 1977"
   V5782 = "HEAD 1977 WAGES"
   V5783 = "ACC HEAD 1977 WAGES"
   V5784 = "HD BONUS,OT,COMM 1977"
   V5785 = "HD PROF PRAC/TRADE 1977"
   V5786 = "LAB PART ROOMER 1977"
   V5787 = "ACC HD LABOR Y EXCL WAGE"
   V5788 = "WIFE 1977 WAGE"
   V5789 = "ACC WIFE 1977 WAGE"
   V5790 = "ASSET PART FARM Y 1977"
   V5791 = "ASSET PART BUS Y 1977"
   V5792 = "ASSET PART ROOMERS 1977"
   V5793 = "ALIMONY Y HEAD 1977"
   V5794 = "HD RENT,INT,DIVIDEND 77"
   V5795 = "WIFE 1977 ASSET Y"
   V5796 = "H+W 1977 TAXABLE Y"
   V5797 = "ACC H+W 1976 ASSET Y"
   V5798 = "H+W 1977 SUPP OTH NONFU"
   V5799 = "H+W 1977 # DEPENDENTS"
   V5800 = "H+W 1977 INCOME TAXES"
   V5801 = "H+W 1977 MARGINAL TAX"
   V5802 = "H+W 1977 ADC,AFDC"
   V5803 = "ACC H+W 1977 ADC,AFDC"
   V5804 = "H+W 1977 SSI"
   V5805 = "H+W 1977 OTHER WELFARE"
   V5806 = "H+W 1977 SOCIAL SECURITY"
   V5807 = "HD 1977 OTHER RETIREMENT"
   V5808 = "HD 1977 UNEMP COMP"
   V5809 = "HD 1977 WRKMANS COMP"
   V5810 = "HD 1977 CHILD SUPPORT"
   V5811 = "HD 1977 HELP FROM RELAT"
   V5812 = "HD 1977 OTHER TRANSFER Y"
   V5813 = "WF 1977 OTHER TRANSFER Y"
   V5814 = "ACC H+W 77 TRANSY NONADC"
   V5815 = "H+W TOT 1977 TRANSFER Y"
   V5816 = "OTH ANN WRK HRS 1977"
   V5817 = "OTH ANN TXBLE Y 1977"
   V5818 = "ACC OTH ANN TX Y 77"
   V5819 = "BKT OTH 1977 ASSET Y"
   V5820 = "OTH 1977 TAXES"
   V5821 = "OTH 1977 ADC/AFDC"
   V5822 = "OTH 1977 SSI"
   V5823 = "OTH 1977 OTHER WELFARE"
   V5824 = "OTH 1977 SOCIAL SECURITY"
   V5825 = "OTH 1977 OTHER RET"
   V5826 = "OTH 1977 UNEPL COMP"
   V5827 = "OTH 1977 WRKMANS COMP"
   V5828 = "OTH 1977 CHILD SUPPORT"
   V5829 = "OTH 1977 HLP FRM RELATIV"
   V5830 = "OTH 1977 MISC TRANSFER"
   V5831 = "OTH 1977 TOT TRANFER $"
   V5832 = "ACC OTH 77 TOT TRANS $"
   V5833 = "# OTH WITH 77 Y"
   V5834 = "# OTH WITH 77 LABOR Y"
   V5835 = "1968 ID"
   V5836 = "1969 ID"
   V5837 = "1970 ID"
   V5838 = "1971 ID"
   V5839 = "1972 ID"
   V5840 = "1973 ID"
   V5841 = "1974 ID"
   V5842 = "1975 ID"
   V5843 = "1976 ID"
   V5844 = "1977 ID"
   V5845 = "INTR ID #"
   V5846 = "INTR INT #"
   V5847 = "DATE OF INT"
   V5848 = "LENGTH OF INT"
   V5849 = "# IN FU"
   V5850 = "AGE OF HEAD"
   V5851 = "SEX OF HEAD"
   V5852 = "AGE OF WIFE"
   V5853 = "# KIDS IN FU"
   V5854 = "AGE YNGST KID IN FU"
   V5855 = "A1 PER <25 IN FU"
   V5856 = "A2 PERS STOP SCHOOL"
   V5857 = "B1 PUB TRANS NEARBY?"
   V5858 = "B2 WTR PUBTRANS GD ENUF"
   V5859 = "B3 OWN CAR/TRUCK"
   V5860 = "B4 # CAR/TRUCK OWN"
   V5861 = "B5 # MI DRIVEN-ALL CARS"
   V5862 = "C1 ACTUAL # ROOMS"
   V5863 = "C2 TYPE DWELLING"
   V5864 = "C3 OWN/RENT OR WHAT"
   V5865 = "C16 RSN NEITR OWN/RENT"
   V5866 = "C20 MOVE SINCE SPR 1977"
   V5867 = "C21 MONTH MOVE"
   V5868 = "C22 WHY MOVE"
   V5869 = "C23 WTR MIGHT MOVE"
   V5870 = "C24 LIKELY HOOD OF MOVE"
   V5871 = "C25 WHY MIGHT MOVE"
   V5872 = "D1 EMPLOYMENT STATUS"
   V5873 = "D2,D3 OCC-2 DIGIT (E)"
   V5874 = "D4 INDUSTRY (E)"
   V5875 = "D5 WORK FOR SELF/OTR (E)"
   V5876 = "D6 WRK FOR GOVT (OT-E)"
   V5877 = "D7 THIS JOB UNION (OT-E)"
   V5878 = "D8 BELONG TO UNION (OT-E"
   V5879 = "D9 WRK FOR GOVT (BTH-E)"
   V5880 = "D10 JOB UNION (BTH-E)"
   V5881 = "D11 BELONG UNION (BTH-E)"
   V5882 = "D12 FORM ED REQUI (E)"
   V5883 = "D13 REQ EXPER/TRAIN (E)"
   V5884 = "D14 WHAT KIND EXPER (E)"
   V5885 = "D15 HOW LG BECO QUAL (E)"
   V5886 = "D16 MANY QUAL PEOPLE?(E)"
   V5887 = "D17 WOMAN HARDER TIME(E)"
   V5888 = "D18 # MO THIS JOB (E)"
   V5889 = "D19 MO STARTED JOB (E)"
   V5890 = "D20 WHAT HAPND PREJOB-E"
   V5891 = "D21 THIS JOB BETTER (E)"
   V5892 = "D22 WHY BETTER/WORSE (E)"
   V5893 = "D23 JOB PAY MORE? (E)"
   V5894 = "D24 WTR OTRS ILL (E)"
   V5895 = "D25 # WKS OTRS ILL (E)"
   V5896 = "D26 WTR SELF ILL (E)"
   V5897 = "D27 # WKS SELF ILL (E)"
   V5898 = "D28 WTR VACATION (E)"
   V5899 = "D29 # WKS VACATION (E)"
   V5900 = "D30 WTR ON STRIKE (E)"
   V5901 = "D31 # WKS ON STRIKE (E)"
   V5902 = "D32 WTR UNEMP (E)"
   V5903 = "D33 # WKS UNEMP (E)"
   V5904 = "D34 # WKS WORKED (E)"
   V5905 = "D35 HR/WK WORKED (E)"
   V5906 = "D36 WTR WKD OVERTIME (E)"
   V5907 = "D38 SLRY/HRLY/OTR (E)"
   V5908 = "D39 PAY/HR SALARY (E)"
   V5909 = "D40 WTR PD OTIME  (E)"
   V5910 = "D41 PAY/HR SRLY OT (E)"
   V5911 = "D42 PAY/HR HRLY (E)"
   V5912 = "D43 PAY/HR HRLY OT (E)"
   V5913 = "D44 HOW PAID (E)"
   V5914 = "D45 PAY/HR OT-OTRS (E)"
   V5915 = "D46 WTR XTRA JOBS (E)"
   V5916 = "D47 OCC-XTRA JOBS (E)"
   V5917 = "D48 TOT # XTRA JOBS (E)"
   V5918 = "D49 PAY/HR XTRA JOB (E)"
   V5919 = "D50 WKS WRKD XTRA JOB(E)"
   V5920 = "D51 HR/WK XTRA JOB (E)"
   V5921 = "D52 MORE WRK AVAIL? (E)"
   V5922 = "D53 PAY/HR WRK MORE (E)"
   V5923 = "D54 WRK MORE MORE WRK?"
   V5924 = "D55 WRK LESS (E)"
   V5925 = "D56 WANT LESS WRK (E)"
   V5926 = "D58 # MI TO WRK (E)"
   V5927 = "D59 MODE JRNY TO WRK (E)"
   V5928 = "D60 HEAD <OR> 45"
   V5929 = "D61 AGE FIRST JOB (E)"
   V5930 = "D62 OCC-AST JOB"
   V5931 = "D63 USEFUL SKILLS?"
   V5932 = "D64 HOW HEAR ABOUT JOB"
   V5933 = "D65 ANY HELP GET JOB"
   V5934 = "D66 WHO HELPED?"
   V5935 = "D67 HOW HELP?"
   V5936 = "D68 DID THEY WRK THER"
   V5937 = "D69 SAY IN GET JOB (E)"
   V5938 = "D70 HOW MUCH SAY"
   V5939 = "D71 ANY ELSE WRK THERE"
   V5940 = "D72 WRK SAME EMPL?"
   V5941 = "D73 # MO PRES EMPL"
   V5942 = "D74 HOW HEAR ABOUT JOB"
   V5943 = "D75 USEFUL SKILLS?"
   V5944 = "D76 ANY HELP GET JOB"
   V5945 = "D77 WHO HELPED"
   V5946 = "D78 HOW HELP"
   V5947 = "D79 THEY WRK PRES EMPL"
   V5948 = "D80 SAY IN YOUR JOB"
   V5949 = "D81 HOW MUCH SAY"
   V5950 = "D82 ANY ELSE WRK THERE"
   V5951 = "D83 AGE RETIRE?"
   V5952 = "D84 RET BEFORE 65"
   V5953 = "D85 ELIG FOR SOC SEC"
   V5954 = "D86 ELIG FOR OTR RET"
   V5955 = "D87 OTR INC WHEN RET"
   V5956 = "D88 RET INC ENOUGH"
   V5957 = "D89 HOME PAID BEFOR 65"
   V5958 = "E1 OCC-JOB SOUGHT (U)"
   V5959 = "E2 PAY/HR JOB SOUGHT (U)"
   V5960 = "E3 WTR NEED TRNG"
   V5961 = "E4 WTR LKG FOR JOB (U)"
   V5962 = "E5 # PLAC LK WRK (U)"
   V5963 = "E6 WONT TK JOB-LOC (U)"
   V5964 = "E7 WONT TK JOB-HRS (U)"
   V5965 = "E8 JOBS NOT WRTH IT (U)"
   V5966 = "E9 PAY/HR UNWRTHY (U)"
   V5967 = "E10 WTR MOVE FOR JOB (U)"
   V5968 = "E11 PAY/HR TO MOVE (U)"
   V5969 = "E12 WHY NOT MOVE (U)"
   V5970 = "E13 WKS LK FOR WRK (U)"
   V5971 = "E14 EVER HAD JOB (U)"
   V5972 = "E15 HEAD UNDER 45 (U)"
   V5973 = "E16 AGE FIRST JOB (U)"
   V5974 = "E17 OCC-FIRST JOB (U)"
   V5975 = "E18 USEFUL SKILLS? (U)"
   V5976 = "E19 HOW HEAR ABOUT JB(U)"
   V5977 = "E20 ANY HELP GET JOB (U)"
   V5978 = "E21 WHO HELPED (U)"
   V5979 = "E22 HOW HELP (U)"
   V5980 = "E23 DID THEY WRK THER(U)"
   V5981 = "E24 SAY IN GET JOB (U)"
   V5982 = "E25 HOW MUCH SAY (U)"
   V5983 = "E26 ANY ELSE WRK THER(U)"
   V5984 = "E27 OCC-LAST JOB (U)"
   V5985 = "E28 IND-LAST JOB (U)"
   V5986 = "E29 WHAT HAPND JOB (U)"
   V5987 = "E30 YR LAST WRKD (U)"
   V5988 = "E31 WTR VACATION (U)"
   V5989 = "E32 # WKS VAC (U)"
   V5990 = "E33 WTR OTR ILL (U)"
   V5991 = "E34 # WKS OTR ILL (U)"
   V5992 = "E35 WTR SELF ILL (U)"
   V5993 = "E36 # WKS SELF ILL (U)"
   V5994 = "E37 WTR ON STRIKE (U)"
   V5995 = "E38 # WKS ON STRIKE (U)"
   V5996 = "E39 WTR UNEMP (U)"
   V5997 = "E40 # WKS UNEMP (U)"
   V5998 = "E41 # WKS WRKD (U)"
   V5999 = "E42 HR/WK WRKD (U)"
   V6000 = "E44 # MI TO WRK (U)"
   V6001 = "E45 MODE JRNY TO WRK (U)"
   V6002 = "F1 RET/DIS,HSWF,STUD (R)"
   V6003 = "F2 YEAR RETIRED (R)"
   V6004 = "F3 WHY RETIRE 1ST MEN(R)"
   V6005 = "F3 WHY RETIRE 2ND MEN(R)"
   V6006 = "F4 RET UNEXPEC ? (R)"
   V6007 = "F5 WHAT HPND MAKE RET(R)"
   V6008 = "F6 GLAD TO RETIRE ? (R)"
   V6009 = "F7 WRKD SINCE RET ? (R)"
   V6010 = "F8 WTR VOLUNT WRK ? (R)"
   V6011 = "F9 WHAT VOLUN WRK (R)"
   V6012 = "F10 PAID WRK IF COULD(R)"
   V6013 = "F11 KIND WRK THAT BE (R)"
   V6014 = "F12 LIV WEL SINCE RET(R)"
   V6015 = "F13 ENUF LIVE ON (R)"
   V6016 = "F14 HOW FL SINCE RET (R)"
   V6017 = "F15 WRK FOR MONEY (R)"
   V6018 = "F16 OCCUPATION (R)"
   V6019 = "F17 INDUSTRY (R)"
   V6020 = "F18 # WKS WRK (R)"
   V6021 = "F19 HR/WK WRKD (R)"
   V6022 = "F20 WORKING NOW (R)"
   V6023 = "F21 WHAT HPND LT JOB (R)"
   V6024 = "F22 JOB IN FUTURE (R)"
   V6025 = "F23 WHEN GET JOB (R)"
   V6026 = "F24 KIND JOB IN MIND (R)"
   V6027 = "F25 NEED TRAINING (R)"
   V6028 = "F26 LOOK FOR JOB (R)"
   V6029 = "F27 # PL LK FOR JOB (R)"
   V6030 = "F28 WNT TK JOB-LOC (R)"
   V6031 = "F29 WNT TK JOB-HRS (R)"
   V6032 = "F30 JOB NOT WRTH IT (R)"
   V6033 = "F31 PAY/HR UNWRTHY (R)"
   V6034 = "G1 MARRITAL STATUS"
   V6035 = "G2 EVER MARRIED"
   V6036 = "G3 WHT HAPN LST MARR"
   V6037 = "G4 MARRIED W/WF OR"
   V6038 = "G5 WTR WF WRKD"
   V6039 = "G6 OCC-WIFE"
   V6040 = "G7 IND-WIFE"
   V6041 = "G8 WTR OTR ILL-WF"
   V6042 = "G9 # WKS OTR ILL-WF"
   V6043 = "G10 WTR WF ILL-WF"
   V6044 = "G11 # WKS WF ILL-WF"
   V6045 = "G12 WTR VAC-WF"
   V6046 = "G13 # WKS VAC-WF"
   V6047 = "G14 WTR ON STR-WF"
   V6048 = "G15 # WKS ON STR-WF"
   V6049 = "G16 WTR WF UNEMP-WF"
   V6050 = "G17 # WKS UNEMP-WF"
   V6051 = "G18 WKS WRKD-WF"
   V6052 = "G19 HR/WK WRKD-WF"
   V6053 = "G20 WF WRK NOW"
   V6054 = "G21 # MI TO WRK-WF"
   V6055 = "G23 MODE JRNY WRK-WF"
   V6056 = "G24 WIFE <45"
   V6057 = "G25 # MO PRES EMPL-WF"
   V6058 = "G26 HOW HEAR JOB-WF"
   V6059 = "G26A USEFUL SKILLS-WF"
   V6060 = "G27 ANY HELP GET JOB-WF"
   V6061 = "G28 WHO HELP-WF"
   V6062 = "G29 HOW HELP-WF"
   V6063 = "G30 WRK THERE-WF"
   V6064 = "G31 SAY IN JOB-WF"
   V6065 = "G32 HOW MUCH SAY-WF"
   V6066 = "G33 ANY ELSE WRK THR-WF"
   V6067 = "G34 WF < 45 OR > 64"
   V6068 = "G35 AGE WF RETIRE"
   V6069 = "G36 RET BEFORE 65-WF"
   V6070 = "G37 OWN SOC SEC-WF"
   V6071 = "G38 OTR RET-WF"
   V6072 = "G39 # HRS HSWRK-WF"
   V6073 = "G40 # HRS HSWRK-HD"
   V6074 = "G42 OTR HELP HSWRK"
   V6075 = "H2 TOT FARM RECTS (BKT)"
   V6076 = "H5 WTR BUSINESS"
   V6077 = "H6 CORP OR UNINCORP"
   V6078 = "H12 WTR WELF/ADC"
   V6079 = "H13 WEL HELP PAY"
   V6080 = "H14 WHAT PAY FOR"
   V6081 = "H15 WTR MEDICAID-HD"
   V6082 = "H18 WTR SOC SEC-HD"
   V6083 = "H19 WTR MEDICARE-HD"
   V6084 = "H23 WTR WF/FRND IN FU"
   V6085 = "H24 WTR WF INCOME 1977?"
   V6086 = "H29 WTR SOC SEC-WF"
   V6087 = "H31 WTR MEDICARE-WF"
   V6088 = "H48 WTR ADC-OTR"
   V6089 = "H49 WTR MEDICAID-OTR"
   V6090 = "H50 WTR SOC SEC-OTR"
   V6091 = "H51 WTR MEDICARE-OTR"
   V6092 = "H52 WTR 1-PERSON FU"
   V6093 = "H53 OTR LKG FOR WRK"
   V6094 = "H54 TOT LKG FOR WRK"
   V6095 = "H57 WTR LUMPSUM PYTS"
   V6096 = "H58 $ LUMPSUM PYTS (BKT)"
   V6097 = "H59 WTR SUPPORT OTRS"
   V6098 = "H60 # SUPPORTED OTRS"
   V6099 = "H62 WTR DEPENDENT OTRS"
   V6100 = "H63 # DEPENDENT OTRS"
   V6101 = "H64 BELONG LABOR UNION"
   V6102 = "H65 WTR HEALTH LMT-HD"
   V6103 = "H66 HOW MUCH HLTH LMT-HD"
   V6104 = "H67 # YRS HAVE COND"
   V6105 = "H68 GET BETTE OR"
   V6106 = "H69 REQU XTRA CARE"
   V6107 = "H70 XTRA COSTS"
   V6108 = "H71 COST SMALL OR"
   V6109 = "H72 FU INC > 17 YRS"
   V6110 = "H73 OTR HLTH LMT-> 17"
   V6111 = "H74 TOT >17 YR HLTH LMT"
   V6112 = "H81 FU INC 0-17 YRS"
   V6113 = "H82 OTR HLTH LMT 0-17"
   V6114 = "H83-88 TOT 0-17 HLTH LMT"
   V6115 = "J1 WTR NEW WIFE"
   V6116 = "J2 EDUCATION-WF"
   V6117 = "J3 WTR OTR SCHLING-WF"
   V6118 = "J4 TYPE OTR SCHLING-WF"
   V6119 = "J6 WTR BA/BS DEGREE-WF"
   V6120 = "J7 WTR ADVANCED DEGRE-WF"
   V6121 = "J8 EDUC-WFS FA"
   V6122 = "J9 EDUC-WFS MO"
   V6123 = "J10#YRS WRKD SINCE 18-WF"
   V6124 = "J11#YRS WRKD FULTIME-WF"
   V6125 = "J12 P TIME WRKD-WF"
   V6126 = "J12 ACC P TIME WRKD-WF"
   V6127 = "K1 WTR NEW HEAD"
   V6128 = "K2 ST GREW UP-FA OF HD"
   V6129 = "K2 CO GREW UP-FA OF HD"
   V6130 = "K2 ST GREW UP-MO OF HD"
   V6131 = "K2 CO GREWUP-MO OF HD"
   V6132 = "K3 OCC-FA OF HD"
   V6133 = "K4 OCC-HDS 1ST JOB"
   V6134 = "K5 # DIFF JOBS OR-HD"
   V6135 = "K6-10 AGE OLDEST KID-HD"
   V6136 = "K6-10 AGE 2ND OLDEST KID"
   V6137 = "K6-10 AGE 3RD OLDEST KID"
   V6138 = "K6-10 TOT # KIDS-HD"
   V6139 = "K6-10 # KIDS BY 25-HD"
   V6140 = "K11 # SIBLING-HD"
   V6141 = "K12 OLDER SIBS?-HD"
   V6142 = "K13 HD GREW UP FARM OR"
   V6143 = "K14,15 ST GREW UP-HD"
   V6144 = "K14,15 CO GREW UP-HD"
   V6145 = "K16 # REGIONS LIVED-HD"
   V6146 = "K16 # STATES LIVED-HD"
   V6147 = "K17 EVERMVD FOR JOB-HD"
   V6148 = "K18 NOTMV FOR JOB-HD"
   V6149 = "K19 PARENTS POO OR?"
   V6150 = "K20-21 EDUC-HDS FA"
   V6151 = "K22-23 EDUC-HDS MO"
   V6152 = "K24 WTR HEAD VET"
   V6153 = "K25 # YR WRD SINCE 18-HD"
   V6154 = "K26 # YR WRD FULTIME-HD"
   V6155 = "K27 P TIME WRKD-HD"
   V6156 = "K27 ACC P TIME WRK-HD"
   V6157 = "K28 EDUCATION-HD"
   V6158 = "K29 WTR OTR TRNG-HD"
   V6159 = "K30 TYPE OTR TRNG-HD"
   V6160 = "K31 TROUBLE READING? HD"
   V6161 = "K32 WTR OTR SCHLNG-HD"
   V6162 = "K33 TYPE OTR SCHLNG-HD"
   V6163 = "K35 WTR BA/BS DEGREE-HD"
   V6164 = "K36 WTR ADVANCED DEGR-HD"
   V6165 = "L1 WHO RESPONDENT"
   V6166 = "L2 # CALLS"
   V6167 = "L3 INSIDE CITY > 50,000?"
   V6168 = "L4 CITY 50,000 OR MORE"
   V6169 = "L5 DIST TO CNTR CITY"
   V6170 = "L6 CITY 50,000 OR MORE"
   V6171 = "L7 DIST TO CNTR CITY"
   V6172 = "L8 INSIDE CITY > 5000"
   V6173 = "TOT 1977 FAM $  INC"
   V6174 = "TOT 1977 HEAD LABOR Y"
   V6175 = "TOT 1977 MISC TRAN Y H+W"
   V6176 = "TOT 77 FAM $ Y/NEEDS"
   V6177 = "ANNUAL FOOD STD"
   V6178 = "HEAD 77 AVG HRLY EARNING"
   V6179 = "WIFE 77 AVG HRLY EARNING"
   V6180 = "REGION - 1978 INT"
   V6181 = "REGION 78 HD GREW UP"
   V6182 = "REGION 78 HD FA GREW UP"
   V6183 = "REGION 78 HD MO GREW UP"
   V6184 = "GEOGRAPHIC MOBILITY"
   V6185 = "ACC 77 $  Y COMPONENTS"
   V6186 = "#MINOR ASSGMTS IN 78"
   V6187 = "#MAJOR ASSGMTS IN 78"
   V6188 = "DU VALUE/ROOM - 1978"
   V6189 = "ACTUL MINUS REQ ROOMS 78"
   V6190 = "PERSONS/ROOM IN 78"
   V6191 = "# 18 OR OLDER IN 78"
   V6192 = "BKT AGE HEAD 1978"
   V6193 = "BKT AGE WIFE 1978"
   V6194 = "EDUCATION 1978 HEAD"
   V6195 = "EDUCATION 1978 WIFE"
   V6196 = "77 FDRL INCM TAX CREDIT"
   V6197 = "MARITAL STATUS"
   V6198 = "DECILE:77 TOT FAM $  Y"
   V6199 = "DECILE:77 INCOME/NEEDS"
   V6200 = "#CHILDS AGE 1-2"
   V6201 = "#CHILDS AGE 3-5"
   V6202 = "#CHILDS AGE 6-13"
   V6203 = "#FEM CHILDS 14-17"
   V6204 = "#MALE CHILDS 14-17"
   V6205 = "#FEM CHILDS 18-20"
   V6206 = "#MALE CHILDS 18-20"
   V6207 = "#FEM CHILDS 21-29"
   V6208 = "#MALE CHILDS 21-29"
   V6209 = "RACE (FROM 1972)"
   V6210 = "SPLIT SAMPLE FILTER"
   V6211 = "11YR FAM COMP CHANGE"
   V6212 = "78 UPDATED FAM WEIGHT"
   V6213 = "UNSKL M CNTY LABOR SUPPL"
   V6214 = "UNSKL F CNTY LABOR SUPPL"
   V6215 = "UNSKLD JOB MARKET 78"
   V6216 = "TYPIC UNSKL WAGE RATE"
   V6217 = "DIF WAGE MALE VS FEM"
   V6218 = "1978 CNTY UNEMP RATE"
   V6219 = "77-78 CNG MARIT STATUS"
   V6220 = "HOUSEHOLD ID # 78"
   V6221 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V5703=99 THEN V5703=.;
IF V5704=999 THEN V5704=.;
IF V5705=99999 THEN V5705=.;
IF V5706=9 THEN V5706=.;
IF V5708=9 THEN V5708=.;
IF V5709=9 THEN V5709=.;
IF V5725=9 THEN V5725=.;
IF V5726=9 THEN V5726=.;
IF V5765=9 THEN V5765=.;
IF V5798=99999 THEN V5798=.;
IF V5819=9 THEN V5819=.;
IF V5846=99 THEN V5846=.;
IF V5850=99 THEN V5850=.;
IF V5852=99 THEN V5852=.;
IF V5855=9 THEN V5855=.;
IF V5856=9 THEN V5856=.;
IF V5857=9 THEN V5857=.;
IF V5858=9 THEN V5858=.;
IF V5859=9 THEN V5859=.;
IF V5860=9 THEN V5860=.;
IF V5861=99999 THEN V5861=.;
IF V5862=9 THEN V5862=.;
IF V5863=9 THEN V5863=.;
IF V5865=9 THEN V5865=.;
IF V5866=9 THEN V5866=.;
IF V5867=99 THEN V5867=.;
IF V5868=9 THEN V5868=.;
IF V5869=9 THEN V5869=.;
IF V5870=9 THEN V5870=.;
IF V5871=9 THEN V5871=.;
IF V5873=99 THEN V5873=.;
IF V5874=99 THEN V5874=.;
IF V5875=9 THEN V5875=.;
IF V5876=9 THEN V5876=.;
IF V5877=9 THEN V5877=.;
IF V5878=9 THEN V5878=.;
IF V5879=9 THEN V5879=.;
IF V5880=9 THEN V5880=.;
IF V5881=9 THEN V5881=.;
IF V5882=9 THEN V5882=.;
IF V5883=9 THEN V5883=.;
IF V5884=9 THEN V5884=.;
IF V5885=999 THEN V5885=.;
IF V5886=9 THEN V5886=.;
IF V5887=9 THEN V5887=.;
IF V5888=999 THEN V5888=.;
IF V5889=99 THEN V5889=.;
IF V5890=9 THEN V5890=.;
IF V5891=9 THEN V5891=.;
IF V5892=9 THEN V5892=.;
IF V5893=9 THEN V5893=.;
IF V5894=9 THEN V5894=.;
IF V5895=99 THEN V5895=.;
IF V5896=9 THEN V5896=.;
IF V5897=99 THEN V5897=.;
IF V5898=9 THEN V5898=.;
IF V5899=99 THEN V5899=.;
IF V5900=9 THEN V5900=.;
IF V5901=99 THEN V5901=.;
IF V5902=9 THEN V5902=.;
IF V5903=99 THEN V5903=.;
IF V5904=99 THEN V5904=.;
IF V5905=99 THEN V5905=.;
IF V5906=9 THEN V5906=.;
IF V5907=9 THEN V5907=.;
IF V5908=9999 THEN V5908=.;
IF V5909=9 THEN V5909=.;
IF V5910=9999 THEN V5910=.;
IF V5911=9999 THEN V5911=.;
IF V5912=9999 THEN V5912=.;
IF V5913=9 THEN V5913=.;
IF V5914=9999 THEN V5914=.;
IF V5915=9 THEN V5915=.;
IF V5916=99 THEN V5916=.;
IF V5917=9 THEN V5917=.;
IF V5918=999 THEN V5918=.;
IF V5919=99 THEN V5919=.;
IF V5920=99 THEN V5920=.;
IF V5921=9 THEN V5921=.;
IF V5922=9999 THEN V5922=.;
IF V5923=9 THEN V5923=.;
IF V5924=9 THEN V5924=.;
IF V5925=9 THEN V5925=.;
IF V5926=99 THEN V5926=.;
IF V5927=9 THEN V5927=.;
IF V5929=99 THEN V5929=.;
IF V5931=9 THEN V5931=.;
IF V5932=9 THEN V5932=.;
IF V5933=9 THEN V5933=.;
IF V5934=9 THEN V5934=.;
IF V5935=9 THEN V5935=.;
IF V5936=9 THEN V5936=.;
IF V5937=9 THEN V5937=.;
IF V5938=9 THEN V5938=.;
IF V5939=9 THEN V5939=.;
IF V5940=9 THEN V5940=.;
IF V5941=999 THEN V5941=.;
IF V5942=9 THEN V5942=.;
IF V5943=9 THEN V5943=.;
IF V5944=9 THEN V5944=.;
IF V5945=9 THEN V5945=.;
IF V5946=9 THEN V5946=.;
IF V5947=9 THEN V5947=.;
IF V5948=9 THEN V5948=.;
IF V5949=9 THEN V5949=.;
IF V5950=9 THEN V5950=.;
IF V5951=99 THEN V5951=.;
IF V5951 GE 98 THEN V5951=.;
IF V5952=9 THEN V5952=.;
IF V5952 GE 8 THEN V5952=.;
IF V5953=9 THEN V5953=.;
IF V5953 GE 8 THEN V5953=.;
IF V5954=9 THEN V5954=.;
IF V5954 GE 8 THEN V5954=.;
IF V5955=9 THEN V5955=.;
IF V5955 GE 8 THEN V5955=.;
IF V5956=9 THEN V5956=.;
IF V5956 GE 8 THEN V5956=.;
IF V5957=9 THEN V5957=.;
IF V5957 GE 8 THEN V5957=.;
IF V5958=99 THEN V5958=.;
IF V5959=9999 THEN V5959=.;
IF V5960=9 THEN V5960=.;
IF V5960 GE 8 THEN V5960=.;
IF V5961=9 THEN V5961=.;
IF V5962=9 THEN V5962=.;
IF V5963=9 THEN V5963=.;
IF V5963 GE 8 THEN V5963=.;
IF V5964=9 THEN V5964=.;
IF V5964 GE 8 THEN V5964=.;
IF V5965=9 THEN V5965=.;
IF V5965 GE 8 THEN V5965=.;
IF V5966=999 THEN V5966=.;
IF V5967=9 THEN V5967=.;
IF V5968=9999 THEN V5968=.;
IF V5969=9 THEN V5969=.;
IF V5970=99 THEN V5970=.;
IF V5971=9 THEN V5971=.;
IF V5972=9 THEN V5972=.;
IF V5973=99 THEN V5973=.;
IF V5975=9 THEN V5975=.;
IF V5976=9 THEN V5976=.;
IF V5977=9 THEN V5977=.;
IF V5978=9 THEN V5978=.;
IF V5979=9 THEN V5979=.;
IF V5980=9 THEN V5980=.;
IF V5981=9 THEN V5981=.;
IF V5982=9 THEN V5982=.;
IF V5983=9 THEN V5983=.;
IF V5984=99 THEN V5984=.;
IF V5985=99 THEN V5985=.;
IF V5986=9 THEN V5986=.;
IF V5987=99 THEN V5987=.;
IF V5988=9 THEN V5988=.;
IF V5989=99 THEN V5989=.;
IF V5990=9 THEN V5990=.;
IF V5991=99 THEN V5991=.;
IF V5992=9 THEN V5992=.;
IF V5993=99 THEN V5993=.;
IF V5994=9 THEN V5994=.;
IF V5995=99 THEN V5995=.;
IF V5996=9 THEN V5996=.;
IF V5997=99 THEN V5997=.;
IF V5998=99 THEN V5998=.;
IF V5999=99 THEN V5999=.;
IF V6000=99 THEN V6000=.;
IF V6001=9 THEN V6001=.;
IF V6003=99 THEN V6003=.;
IF V6004=9 THEN V6004=.;
IF V6005=9 THEN V6005=.;
IF V6006=9 THEN V6006=.;
IF V6007=9 THEN V6007=.;
IF V6008=9 THEN V6008=.;
IF V6009=9 THEN V6009=.;
IF V6010=9 THEN V6010=.;
IF V6011=9 THEN V6011=.;
IF V6012=9 THEN V6012=.;
IF V6013=9 THEN V6013=.;
IF V6014=9 THEN V6014=.;
IF V6015=9 THEN V6015=.;
IF V6016=9 THEN V6016=.;
IF V6017=9 THEN V6017=.;
IF V6018=99 THEN V6018=.;
IF V6019=99 THEN V6019=.;
IF V6020=99 THEN V6020=.;
IF V6021=99 THEN V6021=.;
IF V6022=9 THEN V6022=.;
IF V6023=9 THEN V6023=.;
IF V6024=9 THEN V6024=.;
IF V6025=99 THEN V6025=.;
IF V6025 GE 98 THEN V6025=.;
IF V6026=9 THEN V6026=.;
IF V6027=9 THEN V6027=.;
IF V6028=9 THEN V6028=.;
IF V6029=9 THEN V6029=.;
IF V6030=9 THEN V6030=.;
IF V6031=9 THEN V6031=.;
IF V6032=9 THEN V6032=.;
IF V6033=9999 THEN V6033=.;
IF V6035=9 THEN V6035=.;
IF V6036=9 THEN V6036=.;
IF V6038=9 THEN V6038=.;
IF V6039=99 THEN V6039=.;
IF V6040=99 THEN V6040=.;
IF V6041=9 THEN V6041=.;
IF V6042=99 THEN V6042=.;
IF V6043=9 THEN V6043=.;
IF V6044=99 THEN V6044=.;
IF V6045=9 THEN V6045=.;
IF V6046=99 THEN V6046=.;
IF V6047=9 THEN V6047=.;
IF V6048=99 THEN V6048=.;
IF V6049=9 THEN V6049=.;
IF V6050=99 THEN V6050=.;
IF V6051=99 THEN V6051=.;
IF V6052=99 THEN V6052=.;
IF V6053=9 THEN V6053=.;
IF V6054=99 THEN V6054=.;
IF V6055=9 THEN V6055=.;
IF V6057=999 THEN V6057=.;
IF V6058=9 THEN V6058=.;
IF V6059=9 THEN V6059=.;
IF V6060=9 THEN V6060=.;
IF V6061=9 THEN V6061=.;
IF V6062=9 THEN V6062=.;
IF V6063=9 THEN V6063=.;
IF V6064=9 THEN V6064=.;
IF V6065=9 THEN V6065=.;
IF V6066=9 THEN V6066=.;
IF V6068=99 THEN V6068=.;
IF V6069=9 THEN V6069=.;
IF V6070=9 THEN V6070=.;
IF V6071=9 THEN V6071=.;
IF V6072=99 THEN V6072=.;
IF V6073=99 THEN V6073=.;
IF V6074=9 THEN V6074=.;
IF V6075=9 THEN V6075=.;
IF V6076=9 THEN V6076=.;
IF V6077=9 THEN V6077=.;
IF V6078=9 THEN V6078=.;
IF V6079=9 THEN V6079=.;
IF V6080=9 THEN V6080=.;
IF V6081=9 THEN V6081=.;
IF V6082=9 THEN V6082=.;
IF V6083=9 THEN V6083=.;
IF V6085=9 THEN V6085=.;
IF V6086=9 THEN V6086=.;
IF V6087=9 THEN V6087=.;
IF V6088=9 THEN V6088=.;
IF V6089=9 THEN V6089=.;
IF V6090=9 THEN V6090=.;
IF V6091=9 THEN V6091=.;
IF V6093=9 THEN V6093=.;
IF V6094=9 THEN V6094=.;
IF V6095=9 THEN V6095=.;
IF V6096=9 THEN V6096=.;
IF V6097=9 THEN V6097=.;
IF V6098=9 THEN V6098=.;
IF V6099=9 THEN V6099=.;
IF V6100=9 THEN V6100=.;
IF V6101=9 THEN V6101=.;
IF V6102=9 THEN V6102=.;
IF V6103=9 THEN V6103=.;
IF V6104=99 THEN V6104=.;
IF V6105=9 THEN V6105=.;
IF V6106=9 THEN V6106=.;
IF V6107=9 THEN V6107=.;
IF V6108=9 THEN V6108=.;
IF V6110=9 THEN V6110=.;
IF V6111=9 THEN V6111=.;
IF V6112=9 THEN V6112=.;
IF V6113=9 THEN V6113=.;
IF V6114=9 THEN V6114=.;
IF V6116=99 THEN V6116=.;
IF V6117=9 THEN V6117=.;
IF V6118=9 THEN V6118=.;
IF V6119=9 THEN V6119=.;
IF V6120=9 THEN V6120=.;
IF V6121=9 THEN V6121=.;
IF V6122=9 THEN V6122=.;
IF V6123=9 THEN V6123=.;
IF V6124=99 THEN V6124=.;
IF V6128=99 THEN V6128=.;
IF V6129=999 THEN V6129=.;
IF V6130=99 THEN V6130=.;
IF V6131=999 THEN V6131=.;
IF V6132=9 THEN V6132=.;
IF V6133=9 THEN V6133=.;
IF V6134=9 THEN V6134=.;
IF V6135=99 THEN V6135=.;
IF V6136=99 THEN V6136=.;
IF V6137=99 THEN V6137=.;
IF V6138=99 THEN V6138=.;
IF V6139=9 THEN V6139=.;
IF V6140=9 THEN V6140=.;
IF V6141=9 THEN V6141=.;
IF V6142=9 THEN V6142=.;
IF V6143=99 THEN V6143=.;
IF V6144=999 THEN V6144=.;
IF V6145=9 THEN V6145=.;
IF V6146=9 THEN V6146=.;
IF V6147=9 THEN V6147=.;
IF V6148=9 THEN V6148=.;
IF V6149=9 THEN V6149=.;
IF V6150=9 THEN V6150=.;
IF V6151=9 THEN V6151=.;
IF V6152=9 THEN V6152=.;
IF V6153=99 THEN V6153=.;
IF V6154=99 THEN V6154=.;
IF V6157=99 THEN V6157=.;
IF V6158=9 THEN V6158=.;
IF V6159=9 THEN V6159=.;
IF V6160=9 THEN V6160=.;
IF V6161=9 THEN V6161=.;
IF V6162=9 THEN V6162=.;
IF V6163=9 THEN V6163=.;
IF V6164=9 THEN V6164=.;
IF V6165=9 THEN V6165=.;
IF V6166=9 THEN V6166=.;
IF V6168=999 THEN V6168=.;
IF V6170=999 THEN V6170=.;
 
file rawdat lrecl=980;
put    
v5702
v5710
v5717
v5718
v5719
v5723
v5724
v5729
v5730
v5731
v5732
v5733
v5735
v5743
v5744
v5745
v5747
v5758
v5768
v5769
v5770
v5771
v5772
v5773
v5776
v5777
v5787
v5788
v5789
v5794
v5795
v5796
v5800
v5801
v5815
v5816
v5817
v5819
v5820
v5831
v5847
v5849
v5850
v5851
v5852
v5860
v5864
v5866
v5867
v5868
v5872
v5875
v5890
v5904
v5905
v5941
v5970
v5986
v5998
v5999
v6051
v6052
v6053
v6057
v6096
v6098
v6102
v6116
v6119
v6127
v6157
v6163
v6173
v6174
v6180
v6185
v6194
v6195
v6197
v6209
v6212
v30257
;

 proc means;
 run; 
